"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var core_1 = require("@sentry/core");
var backend_1 = require("./backend");
var version_1 = require("./version");
/**
 * The Sentry Node SDK Client.
 *
 * @see NodeOptions for documentation on configuration options.
 * @see SentryClient for usage documentation.
 */
var NodeClient = /** @class */ (function (_super) {
    tslib_1.__extends(NodeClient, _super);
    /**
     * Creates a new Node SDK instance.
     * @param options Configuration options for this SDK.
     */
    function NodeClient(options) {
        return _super.call(this, backend_1.NodeBackend, options) || this;
    }
    /**
     * @inheritDoc
     */
    NodeClient.prototype.prepareEvent = function (event, scope, hint) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                event.platform = event.platform || 'node';
                event.sdk = tslib_1.__assign({}, event.sdk, { name: version_1.SDK_NAME, packages: tslib_1.__spread(((event.sdk && event.sdk.packages) || []), [
                        {
                            name: 'npm:@sentry/node',
                            version: version_1.SDK_VERSION,
                        },
                    ]), version: version_1.SDK_VERSION });
                if (this.getOptions().serverName) {
                    event.server_name = this.getOptions().serverName;
                }
                return [2 /*return*/, _super.prototype.prepareEvent.call(this, event, scope, hint)];
            });
        });
    };
    return NodeClient;
}(core_1.BaseClient));
exports.NodeClient = NodeClient;
//# sourceMappingURL=client.js.map