"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MIME_TYPE_MAP = exports.MessageSubType = exports.MessageType = void 0;
var MessageType;
(function (MessageType) {
    MessageType["TEXT"] = "text";
    MessageType["POSTMAN_JSON"] = "postman_json";
    MessageType["JSON"] = "json";
    MessageType["XML"] = "xml";
    MessageType["HTML"] = "html";
    MessageType["BINARY"] = "binary";
})(MessageType || (exports.MessageType = MessageType = {}));
var MessageSubType;
(function (MessageSubType) {
    MessageSubType["BASE64"] = "base64";
    MessageSubType["HEX"] = "hex";
})(MessageSubType || (exports.MessageSubType = MessageSubType = {}));
exports.MIME_TYPE_MAP = {
    [MessageType.TEXT]: 'text/plain',
    [MessageType.HTML]: 'text/html',
    [MessageType.POSTMAN_JSON]: 'application/json',
    [MessageType.JSON]: 'application/json',
    [MessageType.XML]: 'application/xml',
    [MessageType.BINARY]: 'application/octet-stream',
};
//# sourceMappingURL=mime-types.js.map