/// <reference types="node" />
import { ConnectionEndEvent, ErrorEvent, CloseEvent, ReconnectEvent, OpenEvent, MessageEvent } from './connection-events';
import type { SecureContextOptions } from '@postman/runtime.core';
export interface SocketIOAgent {
    connect(options: ConnectionOptions): SocketIOConnection | Promise<SocketIOConnection>;
}
export interface SocketIOConnection {
    publish(eventName: string, payload: Array<unknown>, opts?: {
        acknowledgement: boolean;
    }): void;
    subscribe(eventName: string): void;
    unsubscribe(eventName: string): void;
    disconnect(code?: number, reason?: string): void;
    on(eventName: 'close', listener: (event: CloseEvent) => void): this;
    on(eventName: 'end', listener: (event: ConnectionEndEvent) => void): this;
    on(eventName: 'error', listener: (event: ErrorEvent) => void): this;
    on(eventName: 'message', listener: (event: MessageEvent) => void): this;
    on(eventName: 'reconnect', listener: (event: ReconnectEvent) => void): this;
    on(eventName: 'open', listener: (event: OpenEvent) => void): this;
    on(eventName: 'subscribed', listener: (event: {
        event: string;
    }) => void): this;
    on(eventName: 'unsubscribed', listener: (event: {
        event: string;
    }) => void): this;
}
export interface ConnectionOptions {
    url: string | URL;
    clientVersion: '2' | '3' | '4';
    connectOptions?: {
        handshakeTimeout?: number;
        handshakePath?: string;
    };
    reconnectOptions?: {
        retryCount?: number;
        retryDelay?: number;
    };
    tlsOptions?: TLSOptions;
    headers: Record<string, string>;
}
export interface TLSOptions {
    rejectUnauthorized?: boolean;
    secureContext?: SecureContextOptions;
}
