"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parsePacket = void 0;
const lodash_1 = require("lodash");
/**
 * A function to remove null and extra properties from a packet. So the packets match their documentation.
 * https://github.com/mqttjs/mqtt-packet
 */
function parsePacket(obj) {
    const { cmd } = obj;
    switch (cmd) {
        case 'connack':
            const connackFields = new Set([
                'cmd',
                'returnCode',
                'reasonCode',
                'sessionPresent',
                'properties',
                'length',
            ]);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && connackFields.has(key));
        case 'suback':
            const subackFields = new Set([
                'cmd',
                'messageId',
                'granted',
                'properties',
                'length',
            ]);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && subackFields.has(key));
        case 'unsuback':
            const unsubackFields = new Set([
                'cmd',
                'messageId',
                'properties',
                'length',
            ]);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && unsubackFields.has(key));
        case 'puback':
        case 'pubrec':
        case 'pubrel':
        case 'pubcomp':
            const pubackFields = new Set([
                'cmd',
                'messageId',
                'reasonCode',
                'properties',
                'length',
            ]);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && pubackFields.has(key));
        case 'publish':
            const publishFields = new Set([
                'cmd',
                'topic',
                'payload',
                'qos',
                'retain',
                'dup',
                'length',
                'properties',
                'messageId',
            ]);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && publishFields.has(key));
        case 'disconnect':
            const disconnectFields = new Set(['cmd', 'reasonCode', 'properties']);
            return (0, lodash_1.pickBy)(obj, (value, key) => value !== null && value !== undefined && disconnectFields.has(key));
        default:
            return (0, lodash_1.pickBy)(obj, (value) => value !== null && value !== undefined);
    }
}
exports.parsePacket = parsePacket;
//# sourceMappingURL=remove-null.js.map