"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseURL = void 0;
/*
    Parses a string URL and validates that it is appropriate for MQTT or MQTT over WebSockets.
*/
function parseURL(str) {
    str = String(str); // For non-TypeScript applications
    // Test if the string doesn't start with a protocol
    if (!/^[a-z0-9+.-]+:\/\//i.test(str)) {
        str = `mqtt://${str}`; // Default protocol
    }
    let url;
    try {
        url = new URL(str);
    }
    catch (_) {
        throw new Error(`Invalid URL "${str}"`);
    }
    if (!url.host && !url.port && !url.pathname) {
        throw new Error(`Invalid URL "${str}"`);
    }
    const validProtocols = [
        'mqtt:',
        'mqtts:',
        'ws:',
        'wss:',
        'wxs:',
        'alis:',
        'tcp:',
        'ssl:',
    ];
    if (!validProtocols.includes(url.protocol)) {
        throw new Error(`Invalid protocol "${url.protocol}//", try "mqtt://" instead`);
    }
    const { port } = url;
    const secureProtocols = ['mqtts:', 'wss:', 'wxs:', 'alis:', 'ssl:'];
    return {
        protocol: url.protocol.replace(/:$/, ''),
        host: url.hostname,
        port: port,
        url: url.href,
        pathname: url.pathname,
        isTLS: secureProtocols.includes(url.protocol),
    };
}
exports.parseURL = parseURL;
//# sourceMappingURL=parse-url.js.map