import type { IConnackPacket, IDisconnectPacket, IPublishPacket, ISubackPacket, IUnsubackPacket, IPubackPacket, IPubrelPacket, IPubrecPacket, IPubcompPacket, ISubscribePacket, IUnsubscribePacket, IPingrespPacket, IPingreqPacket, IAuthPacket } from 'mqtt-packet';
import { MessageProperties, QoS, SubscriptionMessage } from './mqtt-message';
export interface SubackPacket extends Omit<ISubackPacket, 'granted'> {
    granted: number[];
}
export declare type Packet = SubackPacket | IUnsubackPacket | IPublishPacket | IDisconnectPacket | IConnackPacket | IPubackPacket | IPubackPacket | IPubrelPacket | IPubrecPacket | IPubcompPacket | ISubscribePacket | IUnsubscribePacket | IPingrespPacket | IAuthPacket | IPingreqPacket;
export interface AgentPublishOptions {
    qos?: QoS;
    retain?: boolean;
    dup?: boolean;
    properties?: MessageProperties;
}
export interface AgentSubscribeOptions extends Omit<SubscriptionMessage, 'name' | 'subscribe'> {
}
