import { SecureContextOptions } from '@postman/runtime.core';
import { AgentPublishOptions, AgentSubscribeOptions, Packet } from '@postman/runtime.mqtt-utils';
import type mqtt from 'mqtt';
export interface MQTTAgent {
    connect(options: ConnectOptions): MQTTConnection | Promise<MQTTConnection>;
}
export interface MQTTConnection {
    publish(topic: string, message: string, options: AgentPublishOptions): void;
    subscribe(topic: string, options: AgentSubscribeOptions): void | Promise<void>;
    unsubscribe(topic: string): void | Promise<void>;
    disconnect(): void | Promise<void>;
    isConnected(): boolean;
    on(eventName: 'incoming-packet', listener: (response: Packet) => void): this;
    on(eventName: 'outgoing-packet', listener: (response: Packet) => void): this;
    on(eventName: 'mqtt-error', listener: (response: mqtt.ErrorWithReasonCode) => void): this;
    on(eventName: 'error', listener: (err: Error) => void): this;
    on(eventName: 'reconnect', listener: (count: number) => void): this;
    on(eventName: 'close', listener: () => void): this;
}
export interface ConnectOptions {
    url: string;
    tlsOptions: TLSOptions | null;
    mqttOptions: MQTTClientOptions | null;
}
export interface MQTTClientOptions {
    clientId?: string;
    version?: 4 | 5;
    cleanSession?: boolean;
    keepAlive?: number;
    autoReconnect?: boolean;
    properties?: {
        sessionExpiryInterval?: number;
        receiveMaximum?: number;
        maximumPacketSize?: number;
        userProperties?: Array<{
            key: string;
            value: string;
        }>;
    };
    lastWill?: {
        payload?: string;
        topic?: string;
        qos?: number;
        retain?: boolean;
        properties?: {
            payloadFormatIndicator?: boolean;
            messageExpiryInterval?: number;
            willDelayInterval?: number;
            responseTopic?: string;
            correlationData?: string;
            contentType?: string;
            userProperties?: Array<{
                key: string;
                value: string;
            }>;
        };
    };
    username?: string;
    password?: string;
}
export interface TLSOptions {
    rejectUnauthorized?: boolean;
    secureContext?: SecureContextOptions;
}
export type { SecureContextOptions };
