"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toItemMetadata = exports.toRawMetadata = void 0;
const js_base64_1 = require("js-base64");
/*
    Converts between Postman-formatted metadata and raw metadata.
*/
function toRawMetadata(metadata) {
    const rawMetadata = [];
    for (const { key, value, disabled } of metadata) {
        if (!disabled) {
            let rawValue = String(value || '');
            if (key.toLowerCase().endsWith('-bin')) {
                if (/^[a-zA-Z0-9+/=]*\s*$/.test(rawValue)) {
                    rawValue = js_base64_1.Base64.toUint8Array(rawValue);
                }
                else {
                    throw new Error('Metadata ending in "-bin" must be base64');
                }
            }
            rawMetadata.push([key, rawValue]);
        }
    }
    return rawMetadata;
}
exports.toRawMetadata = toRawMetadata;
function toItemMetadata(rawMetadata) {
    const metadata = [];
    for (const [key, rawValue] of rawMetadata) {
        let value;
        if (rawValue instanceof Uint8Array) {
            value = js_base64_1.Base64.fromUint8Array(rawValue);
        }
        else {
            value = rawValue;
        }
        metadata.push({ key, value });
    }
    return metadata;
}
exports.toItemMetadata = toItemMetadata;
//# sourceMappingURL=metadata.js.map