"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.set = exports.get = void 0;
// Toned down version of lodash.get
// This only does not support array indexes in path
function get(obj, path) {
    if (!obj || typeof obj !== 'object' || !path || typeof path !== 'string') {
        return undefined;
    }
    const keys = path.split('.');
    if (!keys.length)
        return undefined;
    let result = obj;
    for (const key of keys) {
        if (result === undefined) {
            return undefined;
        }
        result = result[key];
    }
    return result;
}
exports.get = get;
// Toned down version of lodash.set
// This only does not support array indexes in path
function set(obj, path, value) {
    if (!obj || typeof obj !== 'object' || !path || typeof path !== 'string') {
        return obj;
    }
    const keys = path.split('.');
    if (!keys.length)
        return obj;
    let result = obj;
    for (let i = 0; i < keys.length - 1; i++) {
        const k = keys[i];
        if (!isSafeProperty(result, k)) {
            return obj;
        }
        if (result[k] == null || typeof result[k] !== 'object') {
            result[k] = Object.create(null);
        }
        result = result[k];
    }
    const lastKey = keys[keys.length - 1];
    if (isSafeProperty(result, lastKey)) {
        result[lastKey] = value;
    }
    return obj;
}
exports.set = set;
function isSafeProperty(obj, prop) {
    if (prop === '__proto__') {
        return false;
    }
    if (prop === 'constructor' && !Object.hasOwn(obj, prop)) {
        return false;
    }
    return true;
}
//# sourceMappingURL=lodash-lite.js.map