/**
 * http methods
 */
export declare const HttpMethod: {
    readonly GET: "get";
    readonly POST: "post";
};
export type HttpMethod = (typeof HttpMethod)[keyof typeof HttpMethod];
export declare const ProxyStatus: {
    readonly SUCCESS_RANGE_START: 200;
    readonly SUCCESS_RANGE_END: 299;
    readonly SERVER_ERROR: 500;
};
export type ProxyStatus = (typeof ProxyStatus)[keyof typeof ProxyStatus];
/**
 * Constants used for region discovery
 */
export declare const REGION_ENVIRONMENT_VARIABLE = "REGION_NAME";
/**
 * Constant used for PKCE
 */
export declare const RANDOM_OCTET_SIZE = 32;
/**
 * Constants used in PKCE
 */
export declare const Hash: {
    SHA256: string;
};
/**
 * Constants for encoding schemes
 */
export declare const CharSet: {
    CV_CHARSET: string;
};
/**
 * Cache Constants
 */
export declare const CACHE: {
    FILE_CACHE: string;
    EXTENSION_LIB: string;
};
/**
 * Constants
 */
export declare const Constants: {
    MSAL_SKU: string;
    JWT_BEARER_ASSERTION_TYPE: string;
    AUTHORIZATION_PENDING: string;
    HTTP_PROTOCOL: string;
    LOCALHOST: string;
};
/**
 * API Codes for Telemetry purposes.
 * Before adding a new code you must claim it in the MSAL Telemetry tracker as these number spaces are shared across all MSALs
 * 0-99 Silent Flow
 * 600-699 Device Code Flow
 * 800-899 Auth Code Flow
 */
export declare const ApiId: {
    acquireTokenSilent: number;
    acquireTokenByUsernamePassword: number;
    acquireTokenByDeviceCode: number;
    acquireTokenByClientCredential: number;
    acquireTokenByCode: number;
    acquireTokenByRefreshToken: number;
};
export type ApiId = (typeof ApiId)[keyof typeof ApiId];
/**
 * JWT  constants
 */
export declare const JwtConstants: {
    ALGORITHM: string;
    RSA_256: string;
    X5T: string;
    X5C: string;
    AUDIENCE: string;
    EXPIRATION_TIME: string;
    ISSUER: string;
    SUBJECT: string;
    NOT_BEFORE: string;
    JWT_ID: string;
};
export declare const LOOPBACK_SERVER_CONSTANTS: {
    INTERVAL_MS: number;
    TIMEOUT_MS: number;
};
//# sourceMappingURL=Constants.d.ts.map