import { InnerClient } from "./core.js";
/**
 *  The Secrets API includes all operations the SDK client can perform on secrets.
 *  Use secret reference URIs to securely load secrets from 1Password: op://<vault-name>/<item-name>[/<section-name>]/<field-name>
 */
export interface SecretsApi {
    /**
     *  Resolve returns the secret the provided secret reference points to.
     */
    resolve(secretReference: string): Promise<string>;
}
export declare class SecretsSource implements SecretsApi {
    #private;
    constructor(inner: InnerClient);
    /**
     *  Resolve returns the secret the provided secret reference points to.
     */
    resolve(secretReference: string): Promise<string>;
}
